
<?php
if (!class_exists('WP_List_Table')) {
    require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
}
class Project_table extends WP_List_Table
{
    public function __construct()
    {
        parent::__construct(array(
            'singular' => 'wp_list_text_link', //Singular label
            'plural' => 'wp_list_test_links', //plural label, also this well be one of the table css class
            'ajax'   => false //We won't support Ajax for this table
        ));
    }

    /**
     * Add extra markup in the toolbars before or after the list
     * @param string $which, helps you decide if you add the markup after (bottom) or before (top) the list
     */
    public function extra_tablenav($which)
    {
        if ($which == "top") {
            //The code that goes before the table is here
            // echo "Hello, I'm before the table";

            echo <<<EOF
                <script>
                    function copyToClipboard(str) {
                        var el = document.createElement('textarea');
                        el.value = str;
                        el.setAttribute('readonly', '');
                        el.style.position = 'fixed';
                        el.style.left = '0';
                        el.style.top = '0';
                        el.style.zIndex = '0';
                        document.body.appendChild(el);
                        el.select();
                        document.execCommand('copy');
                        document.body.removeChild(el);
                    }
                </script>
EOF;
        }
        if ($which == "bottom") {
            //The code that goes after the table is there
            // echo "Hi, I'm after the table";
        }
    }

    public function get_columns()
    {
        $columns = array(
            'cb'        => '<input type="checkbox" />',
            'col_project_name' => 'プロジェクト',
            'col_short_code' => 'ショートコード',
            'col_created_at'    => '創造時間',
            'col_updated_at'      => '変更時間'
        );
        return $columns;
    }

    public function get_sortable_columns()
    {
        return array(
            'col_project_name'  => array('project_name', false),
            'col_created_at' => array('created_at', false),
            'col_updated_at'   => array('updated_at', false),
        );
    }

    public function get_bulk_actions()
    {
        $actions = array(
            // 'delete'    => 'Delete'
        );
        return $actions;
    }

    public function prepare_items()
    {
        global $wpdb;
        /* -- Preparing your query -- */
        $query = "SELECT * FROM {$wpdb->prefix}abtest_project";

        if (isset($_POST['s'])) {
            $query .= " WHERE project_name LIKE '%{$_POST['s']}%'";
        }

        /* -- Ordering parameters -- */
        //Parameters that are going to be used to order the result
        $orderby = !empty($_GET["orderby"]) ? $_GET["orderby"] : 'id';
        $order = !empty($_GET["order"]) ? $_GET["order"] : 'DESC';
        if (!empty($orderby) & !empty($order)) {
            $query .= ' ORDER BY ' . $orderby . ' ' . $order;
        }

        /* -- Pagination parameters -- */
        //Number of elements in your table?
        $totalitems = $wpdb->query($query); //return the total number of affected rows
        //How many to display per page?
        $perpage = 5;
        //Which page is this?
        $paged = !empty($_GET["paged"]) ? $_GET["paged"] : 0;
        //Page Number
        if (empty($paged) || !is_numeric($paged) || $paged <= 1) {
            $paged = 1;
        } //How many pages do we have in total? 
        if (!empty($paged) && !empty($perpage)) {
            $offset = ($paged - 1) * $perpage;
            $query .= ' LIMIT ' . (int)$offset . ',' . (int)$perpage;
        } /* -- Register the pagination -- */
        $this->set_pagination_args(array(
            "total_items" => $totalitems,
            "per_page" => $perpage,
        ));
        //The pagination links are automatically built according to those parameters

        /* -- Register the Columns -- */
        $columns = $this->get_columns();
        $hidden = array();
        $sortable = $this->get_sortable_columns();
        $this->_column_headers = array($columns, $hidden, $sortable);

        /* -- Fetch the items -- */
        $this->items = $wpdb->get_results($query, ARRAY_A);
    }

    public function column_default($item, $column_name)
    {
        switch ($column_name) {
            case 'col_project_name':
                $actions = array(
                    'edit'      => sprintf('<a href="?page=%s&action=%s&project=%s">編集</a>', $_REQUEST['page'], 'edit', $item['id']),
                    'delete'    => sprintf('<a href="?page=%s&action=%s&project=%s">削除</a>', $_REQUEST['page'], 'delete', $item['id']),
                );
                $title = sprintf('<a href="?page=%s&action=%s&project=%s">%s</a>', $_REQUEST['page'], 'edit', $item['id'], $item['project_name']);
                return sprintf('%1$s %2$s', $title, $this->row_actions($actions));
            case 'col_short_code':
                return sprintf('<span>[abtest id=%1$s]</span> <i style="cursor:pointer;" onclick="copyToClipboard(`[abtest id=%1$s]`)" class="wp-menu-image dashicons-before dashicons-admin-page"></i>', $item['id']);
            case 'col_created_at':
                return $item['created_at'];
            case 'col_updated_at':
                return $item['updated_at'];
            default:
                return $item[$column_name]; //Show the whole array for troubleshooting purposes
        }
    }

    public function column_cb($item)
    {
        return sprintf(
            '<input type="checkbox" name="abtest[]" value="%s" />',
            $item->id
        );
    }
}
