<?php
/*
Plugin Name: A/Bテスト
*/

register_activation_hook(__FILE__, function () {
	global $wpdb;
	require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
	dbDelta("
	CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}abtest_project` (
		`id` int(11) NOT NULL AUTO_INCREMENT,
		`project_name` varchar(255) DEFAULT NULL,
		`created_at` datetime DEFAULT NULL,
		`updated_at` datetime DEFAULT NULL,
		PRIMARY KEY (`id`)
	) ENGINE=MyISAM DEFAULT CHARSET=utf8;");
	dbDelta("
	CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}abtest_item` (
		`id` int(11) NOT NULL AUTO_INCREMENT,
		`project_id` int(11) DEFAULT NULL,
		`content` text DEFAULT NULL,
		`item_index` varchar(255) DEFAULT NULL,
		PRIMARY KEY (`id`)
	) ENGINE=MyISAM DEFAULT CHARSET=utf8;
	");
});




function project_list()
{
	require_once('Project_table.php');
	echo '<div class="wrap"><h1 class="wp-heading-inline">プロジェクト</h1>';
	printf('<a class="page-title-action" href="?page=%s&action=%s">新規追加</a>', $_REQUEST['page'], 'add');
	$myListTable = new Project_table();
	$myListTable->prepare_items();

	echo '<form method="post"><input type="hidden" name="page" value="my_list_test" />';
	$myListTable->search_box('search', 'search_id');
	echo '</form>';
	$myListTable->display();

	echo '</div>';
}

function project_edit($project_id)
{
	global $wpdb;
	$item_table = "{$wpdb->prefix}abtest_item";
	$project_table = "{$wpdb->prefix}abtest_project";
	if (isset($_POST['mode'])) {
		$wpdb->update($project_table, array(
			'project_name' => $_POST['project_name'],
			'updated_at' => date('Y-m-d H:i:s')
		), array('id' => $project_id));
		foreach ($_POST['content'] as $index => $content) {
			$wpdb->delete($item_table, array('item_index' => $index));
			$wpdb->insert($item_table, array('project_id' => $project_id, 'content' => $content, 'item_index' => $index));
		}

		echo '<div class="notice notice-success is-dismissible">
			<p>更新しました。</p>
		</div>';
	}

	$project = $wpdb->get_row("SELECT * FROM {$project_table} WHERE id={$project_id}", ARRAY_A);

	$items = $wpdb->get_results("SELECT * FROM {$item_table} WHERE project_id={$project_id} ORDER BY item_index", ARRAY_A);
	echo <<<EOF
		<div class='wrap'><h2>編集</h2>
			<form method="post" action="">
				<input type='hidden' name='mode' value='save'>
				<table class="form-table" role="presentation">

					<tbody>
						<tr>
							<th scope="row"><label for="blogname">プロジェクト</label></th>
							<td><input name="project_name" type="text" id="project_name" required value="{$project['project_name']}" class="regular-text" style='width:100%;'></td>
						</tr>

EOF;
	$labels = 'ABCDEFGHIJKLMNOP';
	for ($i = 0; $i < 5; $i++) {
		$content = '';
		$item_index = $project_id . '_' . $i;
		if (isset($items[$i])) {
			$content = $items[$i]['content'];
		}
		echo "			<tr>
							<th scope='row'><label>コンテンツ{$labels[$i]}</label></th>
							<td><textarea name='content[$item_index]' class='regular-text' style='width:100%;'>{$content}</textarea></td>
						</tr>
		";
	}

	echo '			</tbody>';
	echo '		</table>';
	echo '		<p class="submit"><input type="submit" name="submit" id="submit" class="button button-primary" value="変更を保存"></p>';
	echo '	</form>';
	echo '</div>';
}

function project_add()
{
	global $wpdb;
	$item_table = "{$wpdb->prefix}abtest_item";
	$project_table = "{$wpdb->prefix}abtest_project";
	if (isset($_POST['mode'])) {
		$wpdb->insert($project_table, array(
			'project_name' => $_POST['project_name'],
			'created_at' => date('Y-m-d H:i:s')
		));
		$project_id = $wpdb->insert_id;
		foreach ($_POST['content'] as $index => $content) {
			$wpdb->insert($item_table, array('project_id' => $project_id, 'content' => $content, 'item_index' => $project_id . '_' . $index));
		}
		echo '<div class="notice notice-success is-dismissible">
			<p>追加しました。</p>
		</div>';
	}

	echo <<<EOF
		<div class='wrap'><h2>新規追加</h2>
			<form method="post" action="">
				<input type='hidden' name='mode' value='save'>
				<table class="form-table" role="presentation">

					<tbody>
						<tr>
							<th scope="row"><label for="blogname">プロジェクト</label></th>
							<td><input name="project_name" type="text" id="project_name" required value="" class="regular-text" style='width:100%;'></td>
						</tr>

EOF;
	$labels = 'ABCDEFGHIJKLMNOP';
	for ($i = 0; $i < 5; $i++) {
		$item_index = $i;
		echo "			<tr>
							<th scope='row'><label>コンテンツ{$labels[$i]}</label></th>
							<td><textarea name='content[$item_index]' class='regular-text' style='width:100%;'></textarea></td>
						</tr>
		";
	}

	echo '			</tbody>';
	echo '		</table>';
	echo '		<p class="submit"><input type="submit" name="submit" id="submit" class="button button-primary" value="追加"></p>';
	echo '	</form>';
	echo '</div>';
}

function project_delete($project_id)
{
	global $wpdb;
	$item_table = "{$wpdb->prefix}abtest_item";
	$project_table = "{$wpdb->prefix}abtest_project";

	$wpdb->delete($project_table, array('id' => $project_id));
	$wpdb->delete($item_table, array('project_id' => $project_id));
	echo "<script>window.location.href = '?page=ab_project'</script>";
}

add_action('admin_menu', function () {
	add_menu_page('A/Bテスト', 'A/Bテスト', 'activate_plugins', 'ab_project', function () {
		$action = $_GET['action'] ?? 'list';
		switch ($action) {
			case 'list':
				project_list();
				break;
			case 'edit':
				project_edit($_GET['project']);
				break;
			case 'add':
				project_add();
				break;
			case 'delete':
				project_delete($_GET['project']);
				break;
			default:
				project_list();
		}
	});
});


add_shortcode('abtest', function ($attr) {
	global $wpdb;
	$item_table = "{$wpdb->prefix}abtest_item";
	$project_table = "{$wpdb->prefix}abtest_project";
	$item = $wpdb->get_row("SELECT * FROM {$item_table} WHERE project_id={$attr['id']} AND content != '' ORDER BY RAND()", ARRAY_A);
	if (!empty($item)) {
		// if (preg_match('/^\[[^.]+\]$/', $item['content']) === 1) {
		return do_shortcode($item['content']);
		// }
		return $item['content'];
	}
	return '';
});
